function P81_i
% Problem 8.1 :	Nonlinear parametric pendulum
% Part i. Unforced and undamped pendulum 

% Define some constants
omega0=1;   % Natural frequency of the pendulum

% Define some parameters for using Runge-Kutta metod
tspan=[0 50];     % Time span to be obtained
% Choose time step smaller than 0.01 sec
optn=odeset('InitialStep',1e-2,'MaxStep',1e-2);

% Simulation with small angle (theta(0)=0.01 radian)
[T1,Y1]=ode45(@(t,x) Npp(t,x,omega0),tspan,[0.01 0],optn);

% Simulation with large angle (theta(0)=3 radian)
[T2,Y2]=ode45(@(t,x) Npp(t,x,omega0),tspan,[3 0],optn);

% Plot and compare simulation results
figure(1); 
subplot(2,1,1); plot(T1,Y1(:,1),'r'); grid on; axis tight; 
xlabel('\bfTime (Sec)'); ylabel('\bfAngle (Rad)');
title('\bfTrajectory of the Pendulum with \theta(0)=0.01 & d\theta/dt(0)=0');
subplot(2,1,2); plot(T2,Y2(:,1),'b--'); grid on; axis tight; 
xlabel('\bfTime (Sec)'); ylabel('\bfAngle (Rad)');
title('\bfTrajectory of the Pendulum with \theta(0)=3 & d\theta/dt(0)=0');
end

function dx=Npp(t,x,omega0)
% Describe nonlinear parametric pendulum motion
dx(1,1)=x(2);
dx(2,1)=-omega0^2*sin(x(1));
end
